/*  Baut die Liste der abhängigen und alternativen Ressourcen für einen gegebenen AG auf.

    Dabei bekommt jede Abhängigkeitsbeziehung einen eigenen Eintrag in der Tabelle scheduling.resource_requirement und
    dröselt sich ggf. durch mehrere Einträge in die Tabelle scheduling.resource_requirement_option in die entsprechenden
    alternativen Ressourcen auf. Ist über die Spalte a2_ksap eine konkreter Arbeitsplatz im AG vorgegeben, dann wird nur für
    diesen Aprbeitsplatz eine Ressource-Option angelegt. Die ansonsten möglichen alternaiven Arbeitsplätze werden dann ignoriert.
    Die Auslastung der Ressourcen beträgt 1 bzw. bei Auswärtsvergabe 0.


    -- TODO AXS: Anderen Wert als 1 für load verwenden. Überlegen, was sinnvoll wäre.
    Außerdem kümmert sich diese Funktion auch um die Kopfkostenstellen bzw. Nebenressourcen. Dabei sind von einer ksvba-Ressource
    weitere ksbva-Ressourcen abhängig. Die Auslastung der Kopfkostenstellen berechnet sich aus ??? .


    Diese Funktion wird durch den Trigger ab2__a_i__resource_requirement__create und während der Terminierung
    (Funktion scheduling.resource_timeline__abk_ab2__termination) gerufen.
*/
SELECT tsystem.function__drop_by_regex( 'translate_ab2_resource_requirements', 'scheduling', _commit => true ); -- alter Funktionsname
SELECT tsystem.function__drop_by_regex( 'ab2__resource_requirements_options__ksvba__from__ab2__create', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__resource_requirements_options__ksvba__from__ab2__create(
      _data ab2,
      _loglevel int DEFAULT TSystem.Log_Get_LogLevel( _user => 'yes' )
  ) RETURNS void as $$

  DECLARE

      _prefix varchar := 'scheduling.ab2__resource_requirements_options__ksvba__from__ab2__create -';

      _parent_ksv      varchar;

      _abk_resource_id int;
      _ab2_resource_id int;

      _abk_requirement_id int;
      _ksv_requirement_id int;

      _resource_record record;

      _ks_top_ksabt text;
      _ksv_sub_requirement_id int;

      _record record;


  BEGIN
      -- Debug
      IF _loglevel >= 4 THEN
          RAISE NOTICE '% a2_id:%;', _prefix, _data.a2_id;
      END IF;

      -- ID der AG-Ressource ermitteln.
      _ab2_resource_id := id FROM scheduling.resource WHERE context = 'ab2' AND context_id = _data.a2_id;
      -- AG-Ressource anlegen, falls diese noch fehlt.
      IF _ab2_resource_id IS null THEN
          -- INSERT INTO scheduling.resource( context, context_id  )
          --      VALUES                    ( 'ab2'  , _data.a2_id )
          --   RETURNING resource.id AS _ab2_resource_id;
          -- Besser einen Fehler werfen. , da die AG-Ressource über den Trigger ab2__a_i__resource_requirement__create angelegt wurden sein sollte.
          RAISE EXCEPTION 'Die Arbeitsgang-Ressource fehlt! (a2_id=%) xtt32007', _data.a2_id; -- Die Arbeitsgang-Ressource fehlt! Diese hätte durch Trigger "ab2__a_i__resource_requirement__create" angelegt wurden sein.
      END IF;

      -- ID der ABK-Ressource ermitteln.
      _abk_resource_id := id FROM scheduling.resource WHERE context = 'abk' AND context_id = _data.a2_ab_ix;
      -- ABK-Ressource anlegen, falls diese noch fehlt.
      IF _abk_resource_id IS null THEN
          -- INSERT INTO scheduling.resource( context, context_id     )
          --      VALUES                    ( 'abk'  , _data.a2_ab_ix )
          --   RETURNING resource.id AS _abk_resource_id;
          -- Besser einen Fehler werfen, da die ABK-Ressource über den Trigger abk__a_i__resource_create angelegt wurden sein sollen.
          RAISE EXCEPTION 'Die ABK-Ressource fehlt! (ab_ix=%) xtt32008', _data.a2_ab_ix; -- Die ABK-Ressource fehlt! Diese hätte durch Trigger "abk__a_i__resource_create" angelegt wurden sein.
      END IF;

      -- Die ABK-Ressource als Abhängigkeit von der AB2-Ressource anlegen.
      IF NOT EXISTS( SELECT true FROM scheduling.resource_requirement WHERE context = 'abk' AND required_by = _ab2_resource_id ) THEN
          INSERT INTO scheduling.resource_requirement ( required_by , context )
          VALUES ( _ab2_resource_id, 'abk' )
          RETURNING id INTO _abk_requirement_id;

          INSERT INTO scheduling.resource_requirement_option ( requirement_id , resource_id, load )
          VALUES ( _abk_requirement_id, _abk_resource_id, 1 );
      END IF;

      -- Die Arbeitsplatz-Ressource als Abhängigkeit von der AB2-Ressource anlegen.
      _ksv_requirement_id := id FROM scheduling.resource_requirement WHERE context = 'ksvba' AND required_by = _ab2_resource_id;

      IF _ksv_requirement_id IS NULL THEN
          INSERT INTO scheduling.resource_requirement ( required_by , context )
          VALUES ( _ab2_resource_id, 'ksvba' )
          RETURNING id
          INTO _ksv_requirement_id;
      END IF;

      -- Debug
      IF _loglevel >= 5 THEN
          RAISE NOTICE 'ksv requirement: %', _ksv_requirement_id;
      END IF;

      -- Lösche die bestehenden Optionen für die Arbeittsplatz-Ressource.
      DELETE FROM scheduling.resource_requirement_option
      WHERE requirement_id = _ksv_requirement_id;

      -- Suche alle Alternativen für die Arbeitsplatz-Ressource.
      FOR _resource_record IN
          SELECT id, context_id
          FROM scheduling.resource
          WHERE context = 'ksvba'
            AND context_id = any( scheduling.ab2__resources__find_possible__ksvba_ksb_id__by__ab2__get( _data.a2_id ) )
      LOOP

          -- Lege die Optionen der Arbeitsplatz-Ressource erneut an.
          INSERT INTO scheduling.resource_requirement_option ( requirement_id, resource_id, load )
          VALUES (
              _ksv_requirement_id,
              _resource_record.id,
              ifthen( scheduling.resource__is_auswaerts( _resource_record.id ), 0, 1 )
          );

          _ks_top_ksabt :=
              ks_top_ksabt FROM ksvba
              JOIN ksv ON ksb_ks_id = ks_id
              WHERE ksb_id = _resource_record.context_id
          ;

          IF _ks_top_ksabt IS NULL THEN
              CONTINUE;
          END IF;

          -- Debug
          IF _loglevel >= 5 THEN
              RAISE NOTICE 'ksv top: %', _ks_top_ksabt;
          END IF;

          _ksv_sub_requirement_id := id FROM scheduling.resource_requirement WHERE required_by = _resource_record.id;

          IF _ksv_sub_requirement_id IS NULL THEN
              INSERT INTO scheduling.resource_requirement ( required_by, context )
              VALUES ( _resource_record.id, 'ksvba' )
              RETURNING id
              INTO _ksv_sub_requirement_id;
          END IF;

          -- Debug
          IF _loglevel >= 5 THEN
              RAISE NOTICE 'ksv top requirement: %', _ksv_sub_requirement_id;
          END IF;

          -- Lösche die bestehenden Optionen für die Kopfkostenstellen-Ressource.
          DELETE FROM scheduling.resource_requirement_option
          WHERE requirement_id = _ksv_sub_requirement_id;

          FOR _record IN
              SELECT scheduling.resource.id
                FROM ksvba
                JOIN scheduling.resource ON context = 'ksvba' and context_id = ksvba.ksb_id
               WHERE ksb_ks_abt = _ks_top_ksabt
          LOOP
              -- Lege die Optionen der Kopfkostenstellen-Ressource erneut an.
              -- TODO AXS: Anderen Wert als 1 für load verwenden. Überlegen, was sinnvoll wäre.
              -- NOTE AXS: Die Spalte load in der Tabelle scheduling.resource_requirement_option darf keine Werte generiert aus dem AG enthalten, sondern sollte einen Wert generiert mit Daten aus der KSV bzw. KSVBA enthalten.
              -- INSERT INTO scheduling.resource_requirement_option ( requirement_id, resource_id, load )
              -- VALUES ( _ksv_sub_requirement_id, _record.id , _data.a2_tm / _data.a2_ta );
              INSERT INTO scheduling.resource_requirement_option ( requirement_id, resource_id, load )
              VALUES ( _ksv_sub_requirement_id, _record.id , 1 );

          END LOOP;

      END LOOP;

  END $$ LANGUAGE plpgsql;
